using System;
using System.Collections.Generic;

struct Jarbol
{
    public long x, h;
    public int id;
    public Jarbol(long x, long h, int id)
    {
        this.x = x;
        this.h = h;
        this.id = id;
    }
}

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        string[] s = Console.ReadLine().Split();
        string[] c = Console.ReadLine().Split();

        Jarbol[] jarbol = new Jarbol[n];
        for (int i = 0; i < n; i++)
            jarbol[i] = new Jarbol(long.Parse(s[i]), long.Parse(c[i]), i);

        long[] res = new long[n];
        for (int i = 0; i < n; i++) res[i] = long.MaxValue;

        // Leva strana
        Stack<Jarbol> stack = new Stack<Jarbol>();
        for (int i = 0; i < n; i++)
        {
            while (stack.Count > 0 && stack.Peek().h < jarbol[i].h)
                stack.Pop();

            if (stack.Count > 0)
            {
                Jarbol j = stack.Peek();
                res[jarbol[i].id] = Math.Min(res[jarbol[i].id], Math.Abs(jarbol[i].x - j.x - (jarbol[i].h - j.h)));
            }

            stack.Push(jarbol[i]);
        }

        // Desna strana
        stack.Clear();
        for (int i = n - 1; i >= 0; i--)
        {
            while (stack.Count > 0 && stack.Peek().h < jarbol[i].h)
                stack.Pop();

            if (stack.Count > 0)
            {
                Jarbol j = stack.Peek();
                res[jarbol[i].id] = Math.Min(res[jarbol[i].id], Math.Abs(j.x - jarbol[i].x - (j.h - jarbol[i].h)));
            }

            stack.Push(jarbol[i]);
        }

        for (int i = 0; i < n; i++)
            Console.WriteLine(res[i] == long.MaxValue ? -1 : res[i]);
    }
}